/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.reader;

import filenet.vw.toolkit.design.visio.model.Connect;
import filenet.vw.toolkit.design.visio.model.DocumentObject;
import filenet.vw.toolkit.design.visio.model.Master;
import filenet.vw.toolkit.design.visio.model.ModelFactory;
import filenet.vw.toolkit.design.visio.model.Page;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.reader.VisioXMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisioReader {
    private DocumentObject m_visioDocument = null;

    public DocumentObject readDocument(String inputFileName) throws Exception {
        List fileList = this.preProcessFile(inputFileName);
        if (fileList == null) {
            return null;
        }
        this.m_visioDocument = ModelFactory.createDocument();
        for (File subFile : fileList) {
            DOMParser parser = new DOMParser();
            parser.parse(subFile.getAbsolutePath());
            Document document = parser.getDocument();
            this.traverse(document);
            subFile.delete();
        }
        return this.m_visioDocument;
    }

    private List preProcessFile(String inputFileName) throws Exception {
        int nIndex;
        LinkedList fileList = new LinkedList();
        VisioXMLParser parser = new VisioXMLParser(new InputStreamReader((InputStream)new FileInputStream(inputFileName), "UTF8"));
        parser.parseTag(1);
        for (nIndex = 0; nIndex < parser.m_documentPropertiesFiles.size(); ++nIndex) {
            fileList.add(parser.m_documentPropertiesFiles.elementAt(nIndex));
        }
        for (nIndex = 0; nIndex < parser.m_mastersFiles.size(); ++nIndex) {
            fileList.add(parser.m_mastersFiles.elementAt(nIndex));
        }
        for (nIndex = 0; nIndex < parser.m_pageFiles.size(); ++nIndex) {
            fileList.add(parser.m_pageFiles.elementAt(nIndex));
        }
        return fileList;
    }

    private void traverse(Node node) {
        NodeList pageNodeList;
        NodeList masterNodeList;
        NodeList document = ((Document)node).getElementsByTagName("DocumentProperties");
        if (document != null && document.item(0) != null) {
            this.readDocumentProperties(document.item(0));
        }
        if ((masterNodeList = ((Document)node).getElementsByTagName("Masters")) != null && masterNodeList.item(0) != null) {
            Node topLevelMaster = masterNodeList.item(0);
            NodeList masters = topLevelMaster.getChildNodes();
            for (int nIndex = 0; nIndex < masters.getLength(); ++nIndex) {
                Node master = masters.item(nIndex);
                if (master == null || !master.getNodeName().equalsIgnoreCase("Master")) continue;
                this.readMasters(master);
            }
        }
        if ((pageNodeList = ((Document)node).getElementsByTagName("Pages")) != null && pageNodeList.item(0) != null) {
            Node topLevelPage = pageNodeList.item(0);
            NodeList pages = topLevelPage.getChildNodes();
            int pageLength = pages.getLength();
            for (int i = 0; i < pageLength; ++i) {
                Node page = pages.item(i);
                if (page == null || !page.getNodeName().equalsIgnoreCase("Page")) continue;
                this.readPages(page);
                NodeList shapes = page.getChildNodes();
                for (int j = 0; j < shapes.getLength(); ++j) {
                    Node shape = shapes.item(j);
                    if (shape == null || !shape.getNodeName().equalsIgnoreCase("Shapes")) continue;
                    this.readShapes(shape);
                }
                NodeList connects = page.getChildNodes();
                for (int j = 0; j < connects.getLength(); ++j) {
                    Node connect = connects.item(j);
                    if (connect == null || !connect.getNodeName().equalsIgnoreCase("Connects")) continue;
                    this.readConnects(connect);
                }
            }
        }
    }

    private void readDocumentProperties(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                Node thisNode = children.item(nIndex);
                if (thisNode.getChildNodes() == null) continue;
                this.setDocumentProperties(thisNode.getNodeName(), thisNode.getChildNodes().item(0));
            }
        }
    }

    private void setDocumentProperties(String tag, Node node) {
        if (tag.equalsIgnoreCase("Title")) {
            if (node != null && node.getNodeName().equalsIgnoreCase("#text")) {
                this.m_visioDocument.setTitle(node.getNodeValue());
            }
        } else if (tag.equalsIgnoreCase("Subject")) {
            if (node != null && node.getNodeName().equalsIgnoreCase("#text")) {
                this.m_visioDocument.setSubject(node.getNodeValue());
            }
        } else if (tag.equalsIgnoreCase("Template")) {
            if (node != null && node.getNodeName().equalsIgnoreCase("#text")) {
                this.m_visioDocument.setTemplate(node.getNodeValue());
            }
        } else if (tag.equalsIgnoreCase("Creator")) {
            if (node != null && node.getNodeName().equalsIgnoreCase("#text")) {
                this.m_visioDocument.setCreator(node.getNodeValue());
            }
        } else if (tag.equalsIgnoreCase("Company") && node != null && node.getNodeName().equalsIgnoreCase("#text")) {
            this.m_visioDocument.setCompany(node.getNodeValue());
        }
    }

    private void readMasters(Node node) {
        Master master = ModelFactory.createMaster();
        NamedNodeMap map = node.getAttributes();
        master.setID(this.getValue(map, "ID"));
        master.setDisplayName(this.getValue(map, "Name"));
        String nameU = this.getValue(map, "NameU");
        if (nameU == null) {
            nameU = this.getValue(map, "Name");
        }
        if (master.getID() != null && nameU != null) {
            master = this.setMasterName(master, nameU);
        }
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int nIndex = 0; nIndex < length; ++nIndex) {
            Node icon = childNodes.item(nIndex);
            if (icon == null || !icon.getNodeName().equalsIgnoreCase("Icon")) continue;
            String iconString = this.getText(icon);
            master.setIcon(iconString);
        }
    }

    private void readPages(Node node) {
        Page page = ModelFactory.createPage();
        if (node.getAttributes() != null) {
            NamedNodeMap map = node.getAttributes();
            page.setID(this.getValue(map, "ID"));
            page.setNameU(this.getValue(map, "Name"));
            if (page.getNameU() == null) {
                page.setNameU(this.getValue(map, "NameU"));
            }
            page.setUniqueID(this.getPageSheet(node));
            if (page.getID() != null && page.getNameU() != null) {
                this.m_visioDocument.getPages().add(page);
            }
        }
    }

    private String getPageSheet(Node parentNode) {
        NodeList nodes = parentNode.getChildNodes();
        int length = nodes.getLength();
        for (int nIndex = 0; nIndex < length; ++nIndex) {
            Node node = nodes.item(nIndex);
            if (node == null || !node.getNodeName().equalsIgnoreCase("PageSheet")) continue;
            return this.getValue(node.getAttributes(), "UniqueID");
        }
        return null;
    }

    private void readShapes(Node parentNode) {
        Page page = this.findPage(parentNode);
        NodeList shapes = parentNode.getChildNodes();
        int length = shapes.getLength();
        for (int nIndex = 0; nIndex < length; ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("Shape")) continue;
            this.readShapes(page, shape);
        }
    }

    private void setSubShapes(Shape parentShape, Node node, Page page) {
        NamedNodeMap map = node.getAttributes();
        Shape shape = ModelFactory.createShape();
        shape.setID(this.getValue(map, "ID"));
        shape.setUniqueID(this.getValue(map, "UniqueID"));
        shape.setType(this.getValue(map, "Type"));
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                String text;
                Node thisNode = children.item(nIndex);
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("Text") && (text = this.getText(thisNode)) != null) {
                    shape.setText(text);
                }
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("XForm")) {
                    this.setShapePosition(shape, thisNode);
                }
                if (thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("Shapes")) continue;
                this.readSubShapes(parentShape, thisNode, page, Boolean.FALSE);
            }
        }
        parentShape.getSubShapes().add(shape);
    }

    private Master setMasterName(Master thisMaster, String masterName) {
        if (masterName.indexOf(46) == -1) {
            thisMaster.setNameU(masterName);
        } else {
            thisMaster.setNameU(masterName.substring(0, masterName.indexOf(46)));
        }
        this.m_visioDocument.getMasters().add(thisMaster);
        return thisMaster;
    }

    private void readGroupedShapes(Page page, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                Node thisNode = children.item(nIndex);
                if (thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("Shapes")) continue;
                this.readSubShapes(null, thisNode, page, null);
                break;
            }
        }
    }

    private void readShapes(Page page, Node node) {
        Vector subShapeList;
        String masterName;
        boolean isGroup = false;
        NamedNodeMap map = node.getAttributes();
        Master thisMaster = this.findMaster(this.getValue(map, "Master"));
        Shape shape = ModelFactory.createShape();
        shape.setID(this.getValue(map, "ID"));
        shape.setUniqueID(this.getValue(map, "UniqueID"));
        shape.setType(this.getValue(map, "Type"));
        if (thisMaster == null && shape.getType() != null && shape.getType().equalsIgnoreCase("Group")) {
            this.readGroupedShapes(page, node);
            isGroup = true;
        }
        NodeList children = node.getChildNodes();
        boolean isIDEFO = false;
        if (children != null) {
            String text = null;
            Boolean isLine = null;
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                Node thisNode = children.item(nIndex);
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("Shapes")) {
                    this.readSubShapes(shape, thisNode, page, new Boolean(isGroup));
                }
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("Text")) {
                    text = this.getText(thisNode);
                }
                if (text == null || isIDEFO) {
                    isIDEFO = true;
                    if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("Prop")) {
                        text = text == null ? this.readProp(shape, thisNode) : this.readProp(shape, thisNode) + "_" + text;
                    }
                }
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("XForm")) {
                    this.setShapePosition(shape, thisNode);
                }
                if (thisMaster != null) continue;
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("XForm1D")) {
                    this.setShapeLine(shape, node);
                    isLine = Boolean.TRUE;
                }
                if (isLine != null || thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("Geom")) continue;
                this.setShapeToolBar(shape, thisNode);
            }
            if (text != null) {
                shape.setText(text);
            }
        }
        if (thisMaster == null && shape.getMaster() == null && (masterName = this.getValue(map, "NameU")) != null) {
            thisMaster = ModelFactory.createMaster();
            thisMaster = this.setMasterName(thisMaster, masterName);
        }
        if (thisMaster != null) {
            shape.setMaster(thisMaster);
            if (thisMaster.getNameU().equalsIgnoreCase("Off-page reference")) {
                this.setShapeReferences(shape, node);
            }
        }
        if (page != null && shape.getMaster() != null) {
            page.getShapes().add(shape);
            if (shape.getNameU() == null) {
                shape.setNameU(shape.getMaster().getNameU());
            }
        }
        if (shape.getMaster() == null && shape.getType() != null && shape.getType().equalsIgnoreCase("Group") && (subShapeList = shape.getSubShapes()) != null && subShapeList.size() > 0) {
            double xOffset = shape.getPinX() - shape.getLocPinX();
            double yOffset = shape.getPinY() - shape.getLocPinY();
            for (int nIndex = 0; nIndex < subShapeList.size(); ++nIndex) {
                Shape subShape = (Shape)subShapeList.elementAt(nIndex);
                subShape.setPinX(subShape.getPinX() + xOffset);
                subShape.setPinY(subShape.getPinY() + yOffset);
            }
        }
    }

    private String getText(Node parentNode) {
        StringBuffer buffer = null;
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("#text")) continue;
            if (buffer == null) {
                buffer = new StringBuffer(shape.getNodeValue());
                continue;
            }
            buffer.append(shape.getNodeValue());
        }
        if (buffer != null) {
            return buffer.toString().trim();
        }
        return null;
    }

    private void readSubShapes(Shape parentShape, Node parentNode, Page page, Boolean isGroup) {
        LinkedList<String> groupShapesList = new LinkedList<String>();
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Object shape = shapes.item(nIndex);
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("Shape")) continue;
            if (isGroup == null) {
                this.readShapes(page, (Node)shape);
                continue;
            }
            if (parentShape != null && isGroup.equals(Boolean.TRUE)) {
                NamedNodeMap map = shape.getAttributes();
                String id = this.getValue(map, "ID");
                if (id == null) continue;
                groupShapesList.add(id);
                continue;
            }
            if (parentShape == null || page == null) continue;
            this.setSubShapes(parentShape, (Node)shape, page);
        }
        if (isGroup != null && isGroup.equals(Boolean.TRUE) && page != null && parentShape != null) {
            for (Object shape : page.getShapes()) {
                if (!groupShapesList.contains(((Shape)shape).getID())) continue;
                parentShape.getSubShapes().add(shape);
            }
        }
    }

    private String readProp(Shape parentShape, Node parentNode) {
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("Value")) continue;
            return this.getText(shape);
        }
        return null;
    }

    private void setShapePosition(Shape parentShape, Node parentNode) {
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            try {
                String text;
                Node shape = shapes.item(nIndex);
                if (shape != null && shape.getNodeName().equalsIgnoreCase("Height")) {
                    text = this.getText(shape);
                    if (parentShape.getHeight() == 0.0) {
                        parentShape.setHeight(Double.parseDouble(text));
                    }
                }
                if (shape != null && shape.getNodeName().equalsIgnoreCase("Width")) {
                    text = this.getText(shape);
                    if (parentShape.getWidth() == 0.0) {
                        parentShape.setWidth(Double.parseDouble(text));
                    }
                }
                if (shape != null && shape.getNodeName().equalsIgnoreCase("PinX")) {
                    text = this.getText(shape);
                    if (parentShape.getPinX() == 0.0) {
                        parentShape.setPinX(Double.parseDouble(text));
                    }
                }
                if (shape != null && shape.getNodeName().equalsIgnoreCase("PinY")) {
                    text = this.getText(shape);
                    if (parentShape.getPinY() == 0.0) {
                        parentShape.setPinY(Double.parseDouble(text));
                    }
                }
                if (shape != null && shape.getNodeName().equalsIgnoreCase("LocPinX")) {
                    text = this.getText(shape);
                    if (parentShape.getLocPinX() == 0.0) {
                        parentShape.setLocPinX(Double.parseDouble(text));
                    }
                }
                if (shape != null && shape.getNodeName().equalsIgnoreCase("LocPinY")) {
                    text = this.getText(shape);
                    if (parentShape.getLocPinY() == 0.0) {
                        parentShape.setLocPinY(Double.parseDouble(text));
                    }
                }
                if (shape == null || !shape.getNodeName().equalsIgnoreCase("Angle")) continue;
                text = this.getText(shape);
                if (parentShape.getAngle() != 0.0) continue;
                parentShape.setAngle(Double.parseDouble(text));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void setShapeLine(Shape shape, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                Node thisNode = children.item(nIndex);
                if (thisNode != null && thisNode.getNodeName() != null && thisNode.getNodeName().equalsIgnoreCase("Line")) {
                    this.setShapeLineHead(shape, thisNode);
                }
                if (thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("Geom")) continue;
                this.setShapeLineType(shape, thisNode);
            }
        }
    }

    private void setShapeLineHead(Shape parentShape, Node parentNode) {
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("BeginArrow")) continue;
            String text = this.getText(shape);
            parentShape.setLine(Integer.parseInt(text));
        }
    }

    private void setShapeToolBar(Shape parentShape, Node parentNode) {
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape != null && shape.getNodeName().equalsIgnoreCase("Ellipse")) {
                parentShape.setNameU("Ellipse");
                if (parentShape.getNameU() == null) continue;
                Master master = this.findEllipseMaster();
                parentShape.setMaster(master);
                return;
            }
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("LineTo")) continue;
            parentShape.setNameU("Rectangle");
            if (parentShape.getNameU() == null) continue;
            Master master = this.findRectangleMaster();
            parentShape.setMaster(master);
            return;
        }
    }

    private void setShapeLineType(Shape parentShape, Node parentNode) {
        NodeList shapes = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < shapes.getLength(); ++nIndex) {
            Node shape = shapes.item(nIndex);
            if (shape != null && shape.getNodeName().equalsIgnoreCase("EllipticalArcTo")) {
                parentShape.setNameU("Arc");
                Master master = this.findArcMaster();
                parentShape.setMaster(master);
                return;
            }
            if (shape != null && shape.getNodeName().equalsIgnoreCase("NURBSTo")) {
                parentShape.setNameU("Freeform Line");
                Master master = this.findFreeFormMaster();
                parentShape.setMaster(master);
                return;
            }
            if (shape == null || !shape.getNodeName().equalsIgnoreCase("LineTo")) continue;
            parentShape.setNameU("Line");
            Master master = this.findLineMaster();
            parentShape.setMaster(master);
            return;
        }
    }

    private Master findRectangleMaster() {
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (!thisMaster.getNameU().equals("Rectangle tool")) continue;
            return thisMaster;
        }
        Master master = ModelFactory.createMaster();
        master.setNameU("Rectangle tool");
        master.setPrompt("Rectangle tool");
        this.m_visioDocument.getMasters().add(master);
        return master;
    }

    private Master findEllipseMaster() {
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (!thisMaster.getNameU().equals("Ellipse tool")) continue;
            return thisMaster;
        }
        Master master = ModelFactory.createMaster();
        master.setNameU("Ellipse tool");
        master.setPrompt("Ellipse tool");
        this.m_visioDocument.getMasters().add(master);
        return master;
    }

    private Master findLineMaster() {
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (!thisMaster.getNameU().equals("Line tool")) continue;
            return thisMaster;
        }
        Master master = ModelFactory.createMaster();
        master.setNameU("Line tool");
        master.setPrompt("Line tool");
        this.m_visioDocument.getMasters().add(master);
        return master;
    }

    private Master findArcMaster() {
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (!thisMaster.getNameU().equals("Arc Tool")) continue;
            return thisMaster;
        }
        Master master = ModelFactory.createMaster();
        master.setNameU("Arc tool");
        master.setPrompt("Arc Tool");
        this.m_visioDocument.getMasters().add(master);
        return master;
    }

    private Master findFreeFormMaster() {
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (!thisMaster.getNameU().equals("Freeform Tool")) continue;
            return thisMaster;
        }
        Master master = ModelFactory.createMaster();
        master.setNameU("Freeform tool");
        master.setPrompt("Freeform Tool");
        this.m_visioDocument.getMasters().add(master);
        return master;
    }

    private String getValue(NamedNodeMap map, String tag) {
        String value;
        Node node = map.getNamedItem(tag);
        if (node != null && (value = node.getNodeValue()) != null) {
            return value.trim();
        }
        return null;
    }

    private Page findPage(Node node) {
        for (Page page : this.m_visioDocument.getPages()) {
            if (!page.getID().equals(this.findPageParent(node))) continue;
            return page;
        }
        return null;
    }

    private String findPageParent(Node node) {
        while (node.getParentNode() != null) {
            if (node.getParentNode().getNodeName().equals("Page")) {
                Node thisNode = node.getParentNode().getAttributes().getNamedItem("ID");
                if (thisNode == null) continue;
                return thisNode.getNodeValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    private void readConnects(Node parentNode) {
        Page page = this.findPage(parentNode);
        NodeList connects = parentNode.getChildNodes();
        for (int nIndex = 0; nIndex < connects.getLength(); ++nIndex) {
            Node connect = connects.item(nIndex);
            if (connect == null || !connect.getNodeName().equalsIgnoreCase("Connect")) continue;
            this.readConnects(page, connect);
        }
    }

    private void readConnects(Page page, Node node) {
        Connect connect = ModelFactory.createConnect();
        NamedNodeMap map = node.getAttributes();
        Shape fromShape = this.findShape(page, this.getValue(map, "FromSheet"));
        if (fromShape == null) {
            return;
        }
        connect.setFromShape(fromShape);
        Shape toShape = this.findShape(page, this.getValue(map, "ToSheet"));
        if (toShape == null) {
            return;
        }
        connect.setToShape(toShape);
        connect.setFromCell(this.getValue(map, "FromCell"));
        connect.setToCell(this.getValue(map, "ToCell"));
        if (page != null) {
            page.getConnects().add(connect);
        }
    }

    private Master findMaster(String masterId) {
        if (masterId == null) {
            return null;
        }
        for (Master thisMaster : this.m_visioDocument.getMasters()) {
            if (thisMaster.getID() == null || !thisMaster.getID().equals(masterId)) continue;
            return thisMaster;
        }
        return null;
    }

    private Shape findShape(Page page, String shapeId) {
        if (page != null) {
            for (Shape thisShape : page.getShapes()) {
                if (thisShape.getID().equals(shapeId)) {
                    return thisShape;
                }
                if (!thisShape.getType().equals("Group")) continue;
                for (Shape subShape : thisShape.getSubShapes()) {
                    if (!subShape.getID().equals(shapeId)) continue;
                    return thisShape;
                }
            }
        }
        return null;
    }

    private void setShapeReferences(Shape shape, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                NamedNodeMap map;
                Node refNode;
                Node thisNode = children.item(nIndex);
                if (thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("User") || (refNode = (map = thisNode.getAttributes()).getNamedItem("NameU")) == null) continue;
                if (refNode.getNodeValue().equals("OPCDShapeID")) {
                    shape.setReferenceShapeId(this.setReferenceValue(thisNode));
                    continue;
                }
                if (!refNode.getNodeValue().equals("OPCDPageID")) continue;
                shape.setReferencePageId(this.setReferenceValue(thisNode));
            }
        }
    }

    private String setReferenceValue(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int nIndex = 0; nIndex < children.getLength(); ++nIndex) {
                Node thisNode = children.item(nIndex);
                if (thisNode == null || thisNode.getNodeName() == null || !thisNode.getNodeName().equalsIgnoreCase("Value")) continue;
                return this.getText(thisNode);
            }
        }
        return null;
    }
}

